# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 10
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR10_strategy.txt
# LLM Suggested Fallback: Not Provided

def harmonious_mirage(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    if current_round == 1:
        return "C"
    
    if current_round <= 3:
        return opp_history[-1]
    
    opp_coop_rate = opp_history.count("C") / len(opp_history)
    
    if 4 <= current_round <= 7:
        if opp_coop_rate >= 0.7:
            if random.random() < 0.2:
                return "D"
            return "C"
        else:
            return "D"
    
    if current_round == 10:
        return "D"
    
    if current_round >= 8:
        if opp_coop_rate >= 0.6:
            return "C"
        else:
            return "D"
    
    return "C"